
 
; Heavy Duty Mains Timer
; two modes: 1: For Cyclic appliances (as a safety timer), 2: Standard as a run timer
; Cyclic such as compressor pumps and household water pumps using compressed air bladder to store pressure
; Standard such as any appliance that you want to run till switched off by timer 

;	ERRORLEVEL -302
;	ERRORLEVEL -306

	list P=12F675
	#include P12F675.inc

;Program Configuration Register 
		__CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_ON & _PWRTE_ON & _WDT_ON & _INTRC_OSC_NOCLKOUT	

;
; RAM 

STORE1				equ	H'20'	; delay counter	
STORE2				equ	H'21'	; delay counter
T_COUNT			equ	H'22'	; timeout counter
ON_FLG				equ	H'23'	; on flag
HOLD_FLG			equ	H'24'	; hold flag
T_OUT_FLG			equ	H'25'	; timeout flag
HOLD_ON			equ	H'26'	; HOLD ON flag
TEMP				equ	H'27'	; temporary
TIMER				equ	H'28'	; timer counter stored value
ON_CURRENT		equ	H'29'	; switch on current level
OFF_CURRENT		equ	H'2A'	; switch off current level
W_TMP				equ	H'2B'	; storage of w before interrupt
STATUS_TMP		equ	H'2C'	; status storage before interrupt
MULTIPLIER			equ	H'2D'	; timer multiplier
OPERATION			equ	H'2E'	; cyclic or standard
FLASHER			equ	H'2F'	; LED flasher
CHANGE			equ	H'30'	; change operation counter
FLASH_RATE		equ	H'31'	; flash rate


; start at memory 0

	org		0			; reset vector
	goto	MAIN
	org		4			; interrupt vector 
	goto	INTERRUPT

; Lookup table
; for 0-152 A/D values the value is divided by 2 to give 0-76 range of values for TIMER. That's 1 to 30minutes
; for 153 to 255 lookup table required
; take 153 from value first so 153 to 255 A/D values becomes 0-102. Lookup table starts at 78, with 1.755 added each step for a 30.58minute to 100minute range
; Timer values above for cyclic use. For the standard setting then timer range is 2.5 to 250m
TIME_LOOKUP
	addwf	PCL,f	; 
	retlw	D'78'	; 0 count ;153 A/D value 78 is when divided by 2.55 = 30.58minutes
	retlw	D'79'
	retlw	D'81'	;
	retlw	D'83'
	retlw	D'85'
	retlw	D'87'
	retlw	D'88'
	retlw	D'90'
	retlw	D'92'
	retlw	D'94'
	retlw	D'95'	; 10count
	retlw	D'97'
	retlw	D'99'
	retlw	D'101'
	retlw	D'102'	; 40 minutes
	retlw	D'104'
	retlw	D'106'
	retlw	D'108'
	retlw	D'109'
	retlw	D'111'
	retlw	D'113'	; 20count
	retlw	D'115'
	retlw	D'116'
	retlw	D'118'
	retlw	D'120'
	retlw	D'122'
	retlw	D'123'
	retlw	D'125'
	retlw	D'127'	; 50minutes
	retlw	D'129'
	retlw	D'130'	; 30count
	retlw	D'132'
	retlw	D'134'
	retlw	D'136'
	retlw	D'137'
	retlw	D'139'
	retlw	D'141'
	retlw	D'143'
	retlw	D'144'
	retlw	D'146'
	retlw	D'148'	; 40count
	retlw	D'150'
	retlw	D'151'
	retlw	D'153'	; 60minute
	retlw	D'155'
	retlw	D'157'
	retlw	D'158'
	retlw	D'160'
	retlw	D'162'
	retlw	D'164'
	retlw	D'166'	; 50count
	retlw	D'167'
	retlw	D'169'
	retlw	D'171'
	retlw	D'173'
	retlw	D'174'
	retlw	D'176'
	retlw	D'178'	; 70minute
	retlw	D'180'
	retlw	D'181'
	retlw	D'183'	; 60count
	retlw	D'185'
	retlw	D'187'
	retlw	D'188'
	retlw	D'190'
	retlw	D'192'
	retlw	D'194'
	retlw	D'195'
	retlw	D'197'
	retlw	D'199'
	retlw	D'201'	; 70count
	retlw	D'202'
	retlw	D'204'	; 80minute
	retlw	D'206'
	retlw	D'208'
	retlw	D'209'
	retlw	D'211'
	retlw	D'213'
	retlw	D'215'
	retlw	D'216'
	retlw	D'218'	; 80count
	retlw	D'220'
	retlw	D'221'
	retlw	D'223'
	retlw	D'225'
	retlw	D'227'
	retlw	D'229'	; 90minute
	retlw	D'230'
	retlw	D'232'
	retlw	D'234'
	retlw	D'236'	; 90count
	retlw	D'237'
	retlw	D'239'
	retlw	D'241'
	retlw	D'243'
	retlw	D'244'
	retlw	D'246'
	retlw	D'248'
	retlw	D'250'
	retlw	D'252'
	retlw	D'253'	; 100count
	retlw	D'255'	; 100minute
	retlw	D'255'
	retlw	D'255'			
; __________________________________________________________________________________________

INTERRUPT
	clrwdt
; interrupt occurs when HOLD/START switch is presseed 
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp
	bcf		STATUS,RP0	; select memory bank 0 

	movlw	D'20'
	call		DELY			; deglitch delay
; check if Hold/Start switch is still low
	btfsc	GPIO,2
	goto	END_INTERRUPT

; check operation mode
	btfsc	OPERATION,0
	goto	SET_LOW	; standard operation. Hold / Start is used as a start for the timer or a timer restart, keep low till acknowledged

; Hold not latched to continuously drive hold LED if  timed out
	btfsc	T_OUT_FLG,0
	goto	END_INTERRUPT

; set GP2 as a low output
SET_LOW
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001011'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	bcf		GPIO,2			; drive Hold LED

END_INTERRUPT
; end interrupt 
	bcf		INTCON,INTF		; clear flag

; end of interrupt reclaim w and status 

	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt
; _______________________________________________________________________________________
MAIN
; set oscillator calibration
	bsf		STATUS,RP0	; bank 1
	call		H'3FF'	 		; oscillator calibration value
	movwf	OSCCAL
	bcf		STATUS,RP0	; select memory bank 0


; set inputs/outputs
	movlw	B'00000001'
	movwf	GPIO		; outputs low/high
	
	
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	bsf		STATUS,RP0; select memory bank 1
; to select the operation mode, WPU is enabled for AN0 input to charge up 10uF capacitor if it is installed. PCON,1 determines if a reset or power up reset
	movlw	B'00000100'	; pullups off except GP2
	btfss	PCON,1		; if clear use WPU on AN0
	movlw	B'00000101'	; pullups off except GP2, GP0 
	movwf	WPU

	movlw	B'00001111'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	movlw	B'00001110'	; settings (pullups enabled) wdt prescaler/128 (18ms x 128 timeout), GP2 interrupt on low
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00100011'		; AN0,AN1 analog inputs 
	btfss	PCON,1		; if clear AN0 off
	movlw	B'00100010'		; AN1 analog input 
	movwf	ANSEL

	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00000000'		; channel 0 left justified, VDD ref etc Channel 1 B'00000100'
	movwf	ADCON0

; check PCON, bit 1. Zero for power up, set after detection
	bsf		STATUS,RP0	; bank 1
	btfsc	PCON,1
	goto	BY_MODE ; bypass mode check
	bsf		PCON,1		; set for next time for check with MCLR reset
	bcf		STATUS,RP0	; select memory bank 0
; wait for charge ~1s
	movlw	D'255'
	call		DELY
	movlw	D'255'
	call		DELY
	movlw	D'255'
	call		DELY
	movlw	D'255'
	call		DELY
; check for software version required after WPU is off. Should stay high for longer if 10uF connected, drop to 0 if no 10uF
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00000100'	; pullups off except GP2
	movwf	WPU
; analog inputs, A/D
	movlw	B'00100011'		; AN0,AN1 analog inputs 
	movwf	ANSEL
	bcf		STATUS,RP0	; select memory bank 0
; wait for drop to 0 if no 10uF
; read AN0 for a value
	;  measure GP0 for current flow 
; set input reading for AN0
	movlw	B'00000000'		; channel 0 left justified, VDD ref etc Channel 1 B'00000100'
	movwf	ADCON0
	movlw	D'100'
	call		DELY		; delay for setting up charge input 
	call		A_D		; read current returned in w register
; result is in w register
	sublw	D'10'
; compare with 10	
	movlw	D'00'
	btfss	STATUS,C
; set operation mode
	movlw	D'01'			; 01 cyclic, 00 standard
	movwf	OPERATION		; cyclic or standard
; wait for discharge ~1s
	movlw	D'255'
	call		DELY
	movlw	D'255'
	call		DELY
	movlw	D'255'
	call		DELY
	movlw	D'255'
	call		DELY

BY_MODE
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
	movlw	B'00000000'		; set any outputs low
	movwf	GPIO

	clrf 		ON_FLG			; on flag
	clrf		HOLD_FLG		; hold flag
	clrf		T_OUT_FLG		; timeout flag
	clrf		FLASHER		; LED flasher

; ****** set current measurement switching levels at AN0********************
; current transformer gives a nominal 1.4VDC per amp as applied to the AN0 injput but this is non linear at low voltage levels due to the diode rectifier.
; The switch on at 1V threshold is for around 0.7A (160W) current draw by the appliance. 

	movlw	D'51'			; for 1V. Calculated as 255 (maximum 8-bit A/D level ) multiplied by XV (X is the required voltage level) divided by 5V. 5V is A/D reference.
	movwf	ON_CURRENT	; switch on current level
	movlw	D'10'			; about 200mV (196mV)  Calculation? see above for on_current
	movwf	OFF_CURRENT	; switch off current level


ENABLE_INTERRUPTS
; interrupts
	bsf		INTCON,GIE	; global interrupt
	bsf		INTCON, INTE; GP2 interrupt enable
	bcf		INTCON,INTF	; clear interrupt flag

; Check operation mode
	btfss	OPERATION	,0	; set is cyclic
	goto	STANDARD		; standard mode

STOP
; prepare low power mode

; if HOLD flag is set, restore GP2 to an input
	movf	HOLD_FLG,w
	btfss	STATUS,Z		; if not zero then a hold flag is set
	goto	NOT_HOLD
; GP2 an input
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00001111'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	bcf		STATUS,RP0; select memory bank 0
NOT_HOLD
; if timed out, keep GP4 high
	movlw	B'00110000'		; GP4 high setting preload
	btfss	T_OUT_FLG,0
	movlw	B'00100000'		; GP4 low
	movwf	GPIO		; outputs set low/high
	clrf		HOLD_FLG	; hold and on flags off
	clrf		ON_FLG
STOP2
	sleep				; stop operations
	nop
; sleep awakes with watchdog timeout and with Hold/Start switch

; 
	btfsc	T_OUT_FLG,0
	goto	STOP2

; check hold switch
	btfss	GPIO,2		; if low then hold switch pressed
	goto	HOLD_LOCK

;  measure GP0 for current flow 
; set input reading for AN0
	movlw	B'00000000'		; channel 0 left justified, VDD ref etc Channel 1 B'00000100'
	movwf	ADCON0
	movlw	D'100'
	call		DELY		; delay for setting up charge input 
	call		A_D		; read current returned in w register
; result is in w register
;   if current off; clear on flag, GP4, GP5  low, and hold off
	movwf	TEMP			; store w
	btfsc	ON_FLG,0		; if on, current needs to drop to near 0 before off	
	goto	TIMER_LOOP
; first current. Check current over value 		
	movf	TEMP,w			; stored alue
	subwf	ON_CURRENT,w	; if over ON_CURRENT, current is detected as on
	btfsc	STATUS,C
	goto	STOP2			; no current detected
I_ON
; current on, GP5 kept on, set 'on flag', measure timer setting at AN1 and start timer,  check for current off and timeout (set GP4 high when timed out)
	btfsc	ON_FLG,0		; if set, bypass counter clear
	goto	BYPASS 
	clrf		T_COUNT		; counter for timing
	goto	TIMER_LOOP
BYPASS	

	incfsz	T_COUNT,f		; timed out if counts above 255
	goto	TIMER_LOOP
TIME
	bsf		T_OUT_FLG,0	; timed out flag
	goto	STOP
TIMER_LOOP
	bsf		ON_FLG,0		; current on flag set

; set timer range
; ** fast test; set at 10
	movlw	D'100'			; 100
	movwf	MULTIPLIER		; 100 gives a timing range from 1-100 minutes 
	clrf		FLASH_RATE
	goto	LP1
; read VR1
READ_VR1
	incf		FLASH_RATE,f
	btfsc	FLASH_RATE,0
	goto	CK_HL
LP1
	bsf		GPIO,5
	call		R_VR1				; result in TIMER
	bcf		GPIO,5
; check for timeout
	movf	T_COUNT,w
	subwf	TIMER,w
	btfss	STATUS,C
	goto	TIME			; timed out
CK_HL
; check hold switch
	btfss	GPIO,2			; if low then hold switch pressed
	goto	HOLD_LOCK

TIMER_RUN	
	movlw	D'140'			; adjustment for timeout
	call		DELY

; check for current off
; set input reading for AN0
	movlw	B'00000000'		; channel 0 left justified, VDD ref etc Channel 1 B'00000100'
	movwf	ADCON0
	movlw	D'100'
	call		DELY		; delay for setting up charge input 
	call		A_D		; read current
	subwf	OFF_CURRENT,w	; if under OFF_CURRENT, current off
	btfsc	STATUS,C
	goto	STOP		; stop. clear on flag, GP4, GP5  low, and hold off

	decfsz	MULTIPLIER,f	; multiplier for 1-60s x multiplier
	goto	READ_VR1
	goto	I_ON

;_______________________________________________________
; HOLD operation

HOLD_LOCK
; set GP2 an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001011'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	bcf		GPIO,2			; drive Hold LED
; set HOLD flag if on flag is clear
;	btfss	ON_FLG,0
;	bsf		HOLD_FLG,0	; hold flag for continuous hold

HOLD_LOOP; 
;check for timeout option and for current off

;	btfss	HOLD_FLG,0	; continuous hold when set
	goto	HOLD_LOOP1	; Hold is off with low current below OFF_CURRENT

CHK_ON_OFF
; measure GP0 for current flow 
; set input reading for AN0
	movlw	B'00000000'		; channel 0 left justified, VDD ref etc Channel 1 B'00000100'
	movwf	ADCON0
	movlw	D'100'
	call		DELY			; delay for setting up charge input 
	call		A_D			; read current (w register)
;Check current over value 		
	movwf	TEMP
	subwf	ON_CURRENT,w	; if over ON_CURRENT, current is detected as on
	btfss	STATUS,C		; if set, current is not over ON_CURRENT
	bcf		GPIO,5			; LED off with current > ON_CURRENT
; Check current under value
	movf	TEMP,w
	subwf	OFF_CURRENT,w; if under OFF_CURRENT, current off
	btfsc	STATUS,C
	bsf		GPIO,5			; LED on with current < OFF_CURRENT 

;Flash LED1

	sleep				; stop operations
	nop
	btfsc	GPIO,5		; is LED1 on (ie over current detected)
	goto	CHK_ON_OFF
	bsf		GPIO,5		; LED1 on
	movlw	D'5'
	call		DELY
	bcf		GPIO,5		; LED1 off
	goto	CHK_ON_OFF


HOLD_LOOP1 ; off when current drops below OFF_CURRENT

WAIT_OFF
; Hold goes off when current drops below OFF_CURRENT
	btfsc	GPIO,5		; is LED1 on 
	goto	LED1_OFF
	bsf		GPIO,5		; LED1 on
	goto	READ_AN
LED1_OFF
	bcf		GPIO,5		; LED1 off
; set input reading for AN0
READ_AN
	movlw	B'00000000'		; channel 0 left justified, VDD ref etc Channel 1 B'00000100'
	movwf	ADCON0
	movlw	D'230'
	call		DELY			; delay for setting up charge input and LED flash rate
	call		A_D			; read current
; result is in w register
	subwf	OFF_CURRENT,w	; if under OFF_CURRENT, current off
	btfsc	STATUS,C
	goto	END_HOLD			
	goto	WAIT_OFF
END_HOLD
	clrf		HOLD_FLG
	goto	STOP			; stop. clear on _flag, GP4, GP5  low, and hold off
; *********************************************
STANDARD ; standard mode
;STOP
; prepare low power mode
	clrwdt
; GP2 an input
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00001111'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	bcf		STATUS,RP0; select memory bank 0
; outputs low
	movlw	B'00100000'		; GP4 low
	movwf	GPIO		; outputs set low/high

	sleep				; stop operations
	nop
; sleep awakes with watchdog timeout and with Hold/Start switch

; check if GP2 is low
	btfsc	GPIO,2	
	goto	STANDARD
GP2_IN_S
; GP2 an input
	bsf		STATUS,RP0; select memory bank 1
	movlw	B'00001111'	; outputs/inputs set 
	movwf	TRISIO		; port data direction register
	bcf		STATUS,RP0; select memory bank 0

; timer
	bsf		GPIO,4			; timer on, relay on

	clrf		T_COUNT		; counter for timing
	goto	TIMER_LOOP_S
LOOP_S	

	incfsz	T_COUNT,f		; timed out if counts above 255
	goto	TIMER_LOOP_S
	goto	STANDARD		; timed out

TIMER_LOOP_S

; set timer range
; ***** timer fast test; set at 10  
	movlw	D'250'			; 250
	movwf	MULTIPLIER		; gives a timing range from 2.5-250 minutes 

; read VR1
READ_VR1_S
	bsf		GPIO,5
	call		R_VR1			; result in TIMER

; check for timeout
	movf	T_COUNT,w
	subwf	TIMER,w
	btfss	STATUS,C
	goto	STANDARD		; timed out

; check hold switch

	incf		FLASH_RATE,f	; flash rate
	btfss	FLASH_RATE,0
	goto	IN2
; set GP2 an output
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001011'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	bcf		GPIO,2			; drive Hold LED
	movlw	D'182'			; adjustment for timeout
	call		DELY
	goto	MULT_1	

; set GP2 an input
IN2
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001111'		; outputs/inputs set 
	movwf	TRISIO			; port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	movlw	D'182'			; adjustment for timeout
	call		DELY

	btfss	GPIO,2			; if low then hold switch pressed
	goto 	GP2_IN_S		; set GP2 as an input and restart timer

MULT_1
	decfsz	MULTIPLIER,f	; multiplier for 1-60s x multiplier
	goto	READ_VR1_S

	incfsz	T_COUNT,f		; timed out if counts above 255
	goto	TIMER_LOOP_S

	bsf		T_OUT_FLG,0	; timed out flag
	goto	STANDARD
	goto	TIMER_LOOP_S		;  continue timer

; _____________________________________________________________________________________
; subroutines

A_D
	bsf		ADCON0,ADON	; A/D on
	movlw	D'3'
	call		DELY
	bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
	clrwdt	; watchdog cleared to prevent reset
	btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	movf	ADRESH,w
	bcf		ADCON0,ADON	; A/D off
	return

; read VR1
R_VR1	
; set input reading for AN1
	movlw	B'00000100'		; channel 1 left justified, VDD ref etc 
	movwf	ADCON0
	movlw	D'100'
	call		DELY		; delay for setting up charge input 
	call		A_D		; read current
	movwf	TIMER
; Processing
; for 0-152 A/D values the value is divided by 2 to give 0-76 range of values for TIMER
	sublw	D'152'		; take w from 152
	btfss	STATUS,C	; if negative then >152 (C=0)
	goto	PROCESS
	bcf		STATUS,C
	rrf		TIMER,f		; divide by 2
; check if 0
	movf	TIMER,w
	btfsc	STATUS,Z	; if zero then set at 1
	movlw	D'1'
	movwf	TIMER		; use original value if it was not 0
	return

PROCESS ; > 152 , so use lookup table
	
; for 153 to 255, lookup table required
; take 153 from value first so 153 to 255 becomes 0-102, with 1.755 added each step

	movlw	D'153'
	subwf	TIMER,w
	call		TIME_LOOKUP	; lookup table
	movwf	TIMER
	return

; delay loop 

DELY ; 1ms per value in store1 approxmately

	movwf	STORE1		; STORE1 is number of loops value
LOOP12	
	movlw	D'255'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP13
	clrwdt	; watchdog cleared to prevent reset
	decfsz	STORE2,f
	goto	LOOP13
	decfsz	STORE1,f
	goto	LOOP12
	return

; subroutine to read EEPROM memory 

EEREAD
	bsf 		STATUS,RP0 	;Bank 1
	movwf 	EEADR 			;Address to read
	bsf 		EECON1,RD		;EE Read
	movf 	EEDATA,W 		;Move data to W
	bcf		STATUS,RP0	;Bank 0
	return

; subroutine to write to EEPROM

EEWRITE	
	bsf 		STATUS,RP0 	;Bank 1
AGAIN
	movwf	EEDATA
	bsf		EECON1,WREN	;Enable write
	movlw 	H'55'			;Unlock write
	movwf 	EECON2 ;
	movlw 	H'AA' ;
	movwf 	EECON2 ;
	bsf 		EECON1,WR 	;Start the write
	bcf		EECON1,WREN
CK_WR
	clrwdt
	btfsc	EECON1,WR
	goto	CK_WR

	bcf		STATUS,RP0	;Bank 0
	return					; value written 
	
	
	end
